#include <iostream>
#include <vector>
#include <string>
#include <strings.h>
using namespace std;

// Generic findMax, with a function object, C++ style.
// Precondition: a.size( ) > 0.
template <typename Object, typename Comparator>
const Object & findMax( const vector<Object> & arr, Comparator isLessThan )
{
    int maxIndex = 0;

    for( int i = 1; i < arr.size( ); ++i )
        if( isLessThan( arr[ maxIndex ], arr[ i ] ) )
            maxIndex = i;

    return arr[ maxIndex ];
}

// Generic findMax, using default ordering.
#include <functional>
template <typename Object>
const Object & findMax( const vector<Object> & arr )
{
    return findMax( arr, less<Object>( ) );
}

int main( )
{
    vector<string> arr = { "ZEBRA", "alligator", "crocodile" };
    
    cout << findMax( arr, []( const string & lhs, const string & rhs )
      { return strcasecmp( lhs.c_str( ), rhs.c_str( ) ) < 0; }
    ) << endl;
    
    cout << findMax( arr ) << endl;

    return 0;
}